/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2212;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm2212.CodeLevel2212;
import ibm.nways.jdm2212.NlsConstants;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxInfo {
    public boolean cc5;
    private static final int RASID = 19;
    private static final int RASSUB = 15;
    public static final String PROPNAME = "BoxInfo.jdm2212.nways.ibm";
    protected static final String PropertiesFile = "properties/Jdm2212.txt";
    public static final String serPath = "ibm.nways.jdm2212.WCDefault";
    public static final String commonGifPath = "/ibm/nways/gifs/24_scale/horizontal/connectors/";
    public static final int PLAT2212_10F = 1;
    public static final int PLAT2212_10H = 2;
    public static final int PLAT2212_40F = 3;
    public static final int PLAT2212_40H = 4;
    public static final int PLAT2212_15F = 5;
    public static final int PLAT2212_15H = 6;
    public static final int PLAT2212_45F = 7;
    public static final int PLAT2212_45H = 8;
    public static final int PMCSLOT1 = 1;
    public static final int PMCSLOT2 = 2;
    public static final int PMCSLOT5 = 5;
    public static final int PMCSLOT6 = 6;
    public static final int SYSTEM = 7;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    public static final int unknown_Model = 0;
    public static final int Model_1U = 1;
    public static final int Model_2U = 2;
    public static final int No_module = 0;
    public static final int Unknown_module = 1;
    public static final int TX_module = 2;
    public static final int FX_module = 3;
    public static final int ATM_module = 4;
    public static final String[] moduleName = new String[]{"", "unknown", "not-present", "eth-fast-1port", "token-ring-1port", "eth-fast-2port", "token-ring-2port", "SystemBoard", "isdn-bri-u-2port", "isdn-bri-st-2port", "isdn-pri-t1j1-1port", "isdn-pri-e1-1port", "compression-encryption", "serial-4port-deep", "isdn-pri-t1j1-2port", "isdn-pri-e1-2port", "mdm-digital-t1j1-1port", "mdm-digital-e1-1port", "mdm-analog-4port", "voice-fxs-2port", "voice-fxo-2port", "voice-em-2port", "serial-4port-pmc"};
    public static final String[] moduleGif = new String[]{"", "4-16mbpstr.gif", "4-16mbpstr.gif", "SysEthCard.gif", "SysTRCard.gif", "etherpci2.gif", "4-16mbpstr.gif", "SystemCard.gif", "isdn-bri-u.gif", "isdn-bri-st.gif", "isdnpri1t1j1.gif", "isdnpri1e1.gif", "compression-encryption.gif", "wanmodule.gif", "isdnpri2t1j1.gif", "isdnpri2e1.gif", "mdt1j11port.gif", "mde11port.gif", "ma4port.gif", "voicefxs2port.gif", "voicefxo2port.gif", "voiceem2port.gif", "wan4portpmc.gif"};
    public static final Point[] moduleLocation = new Point[]{null, new Point(209, 9), new Point(389, 9), new Point(209, 41), new Point(389, 41), new Point(216, 20), null, new Point(423, 26), new Point(216, 20)};
    public static final Point[] moduleLocationcc5 = new Point[]{null, new Point(209, 9), new Point(389, 9), new Point(209, 41), new Point(389, 41), new Point(216, 20), null, new Point(216, 20), new Point(423, 26)};
    public static final Point[] moduleLocationR2 = new Point[]{null, new Point(209, 9), new Point(389, 9), new Point(209, 41), new Point(389, 41), new Point(112, 11), new Point(219, 1), null, new Point(112, 11), new Point(219, 1), new Point(423, 24)};
    private ModuleInfo[] moduleInfo = new ModuleInfo[]{null, null, null, null, null, null, null};
    public static final OID[] modelSysOID = new OID[]{new OID(".0.0.0"), new OID(".1.3.6.1.4.1.2.3.37")};
    public static final String[] modelGif = new String[]{"", "2212-10F.gif", "2212-10F.gif", "2212-40F.gif", "2212-40F.gif", "2212-15F.gif", "2212-15F.gif", "2212-45F.gif", "2212-45F.gif"};
    public static final String[] modelName = new String[]{"unknownModel", "10F", "10H", "40F", "40H", "15F", "15H", "45F", "45H"};
    public static final Point[] systemLocation = new Point[]{null, new Point(55, 13), new Point(55, 13), new Point(210, 75), new Point(210, 75), new Point(55, 13), new Point(55, 13), new Point(210, 75), new Point(210, 75)};
    private GenModel deviceModel;
    private JdmBrowser deviceBrowser;
    private ResourceBundle jdm2212Bundle;
    private CodeLevel2212 codeLevel;
    private ModelInfo adapGraphic;
    private GenModel systemModel;
    private GenModel portsModel;
    private GenModel atmModel;
    private GenModel interfaceModel;
    private int deviceStatus = 0;
    private GraphicPanel deviceGraphic;
    private CookieTray frontView;
    private int deviceType;
    private boolean isApplication;
    private boolean isBox = false;
    private boolean isDeviceUp = false;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser, ResourceBundle resourceBundle) {
        String string = "BoxInfo";
        if (RAS.isEnabled(19, 15)) {
            RAS.trace(19, 15, this, string, "2212:BoxInfo  constructor");
        }
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        this.jdm2212Bundle = resourceBundle;
        this.getInitialBoxInfo();
    }

    private void getInitialBoxInfo() {
        String string = "getInitialBoxInfo";
        String string2 = "";
        String string3 = "";
        try {
            if (this.deviceModel == null) {
                this.deviceModel = (GenModel)this.deviceBrowser.getModel();
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "Got Jdm2212 Model Impl");
                }
            }
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "Got Initial");
            }
            ModelInfo modelInfo = this.deviceModel.getInfo("Initial");
            OID oID = new OID("1.3.6.1.4.1.2.3.37");
            Serializable serializable = modelInfo.get("Initial.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "Can't talk to the Device " + serializable.toString());
                }
                this.isDeviceUp = false;
                this.isBox = false;
                new BoxDownMsg(this.deviceBrowser.getFrame(), this.jdm2212Bundle.getString("deviceName"));
                return;
            }
            String string4 = serializable.toString();
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "sysOid: " + string4);
            }
            OID oID2 = new OID(string4);
            this.isBox = oID.equals(oID2);
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "isBox= " + this.isBox);
            }
            if (!this.isBox) {
                new WrongSysOidMsg(this.deviceBrowser.getFrame(), this.jdm2212Bundle.getString("deviceName"));
            } else {
                this.deviceStatus = 1;
            }
            this.deviceType = 0;
            if (this.deviceStatus == 1) {
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "AllisWell");
                }
                string2 = modelInfo.get("Initial.SysDescr").toString();
                string3 = modelInfo.get("Initial.PlatformType").toString();
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "ModelNum: " + string3);
                }
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "description: " + string2);
                }
                this.deviceType = new Integer(string3);
                this.isDeviceUp = true;
            }
            System.out.println("ModelNum = " + string3 + "   " + this.deviceType);
            if (this.deviceType == 28) {
                this.deviceType = 1;
            } else if (this.deviceType == 29) {
                this.deviceType = 2;
            } else if (this.deviceType == 30) {
                this.deviceType = 3;
            } else if (this.deviceType == 31) {
                this.deviceType = 4;
            } else if (this.deviceType == 34) {
                this.deviceType = 5;
            } else if (this.deviceType == 35) {
                this.deviceType = 6;
            } else if (this.deviceType == 36) {
                this.deviceType = 7;
            } else if (this.deviceType == 37) {
                this.deviceType = 8;
            } else if (this.deviceType == 1) {
                this.deviceType = 4;
            } else {
                this.isBox = false;
                this.deviceStatus = 3;
                if (RAS.isEnabled(19, 15)) {
                    RAS.trace(19, 15, this, string, "Bad deviceType received" + this.deviceType);
                }
            }
            if (this.deviceType > 4 && RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "Release 2 hardware detected");
            }
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "device Type === " + this.deviceType);
            }
            if (this.isBox) {
                System.out.println("DeviceType = " + this.deviceType);
                this.codeLevel = new CodeLevel2212(string2);
                if (!this.codeLevel.atOrAboveLevel(3, 3, 0, 0)) {
                    if (RAS.isEnabled(19, 15)) {
                        RAS.trace(19, 15, this, string, "Code Level CC4");
                    }
                    this.cc5 = false;
                    System.out.println("CC4");
                } else {
                    if (RAS.isEnabled(19, 15)) {
                        RAS.trace(19, 15, this, string, "Code Level CC5");
                    }
                    this.cc5 = true;
                    System.out.println("CC5");
                }
            }
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "Code level = MRS " + this.codeLevel);
                return;
            }
        }
        catch (Exception exception) {
            this.isDeviceUp = false;
            this.isBox = false;
            RAS.logError(19, 15, this, string, "EXCEPTION_GETTING_MODELINFO", (Object)"Initial", (Object)"Jdm2212Model");
            RAS.logException(19, 15, this, string, exception);
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public boolean deviceOK() {
        return this.isDeviceUp || this.isBox;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public GenModel getSystemModel() {
        return this.systemModel;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public String getSerPath() {
        return serPath;
    }

    public CookieTray getFrontView() {
        return this.frontView;
    }

    public GenModel getPortsModel() {
        return this.portsModel;
    }

    public GenModel getInterfaceModel() {
        return this.interfaceModel;
    }

    public CodeLevel2212 getCodeLevel() {
        return this.codeLevel;
    }

    public GraphicPanel getDeviceGraphic() {
        Object object;
        Object object2;
        Object object3;
        String string;
        int n;
        Properties properties;
        Serializable serializable;
        String string2 = "getDeviceGraphic";
        String string3 = "?";
        if (this.deviceGraphic != null) {
            return this.deviceGraphic;
        }
        try {
            serializable = new URL(this.deviceBrowser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            properties = null;
            RAS.logError(19, 15, this, string2, "EXCEPTION_GETTING_PROPERTIES", (Object)PropertiesFile);
            RAS.logException(19, 15, this, string2, exception);
        }
        JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get("box.layout.scheme"));
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string2, "Layout Scheme: " + serializable);
            }
            n = (Integer)serializable;
            jdmLayout.setScheme(n);
            string = (String)((Hashtable)properties).get("box.layout.fractions");
            object3 = new StringTokenizer(string);
            object2 = new float[((StringTokenizer)object3).countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < ((float[])object2).length && ((StringTokenizer)object3).hasMoreTokens()) {
                object = ((StringTokenizer)object3).nextToken();
                try {
                    object2[n2] = Float.valueOf((String)object).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    RAS.logError(19, 15, this, string2, "EXCEPTION_CALCULATING_FRACTIONS");
                    RAS.logException(19, 15, this, string2, (Exception)numberFormatException);
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts((float[])object2);
            }
        } else {
            n = 0;
            jdmLayout.setScheme(n);
        }
        GraphicContainer graphicContainer = new GraphicContainer();
        serializable = new HelpRef((Object)this);
        if (RAS.isEnabled(19, 15)) {
            RAS.trace(19, 15, this, string2, "Helpref reference: " + serializable.toString());
        }
        string = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)string);
        try {
            this.systemModel = (GenModel)this.deviceModel.getComponent("System");
        }
        catch (Exception exception) {
            RAS.logError(19, 15, this, string2, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"System", (Object)"Jdm2212Model");
            RAS.logException(19, 15, this, string2, exception);
        }
        object3 = new Label(String.valueOf(NlsConstants.my2212Bundle.getString("2212Name")) + modelName[this.deviceType], 1);
        ((Component)object3).setLocation(new Point(35, 0));
        graphicContainer.add((Component)object3);
        this.frontView = this.createModel(this.systemModel);
        try {
            string3 = "ConfigurationFolder";
            object2 = (GenModel)this.deviceModel.getComponent(string3);
            string3 = "SystemFolder";
            GenModel genModel = (GenModel)object2.getComponent(string3);
            string3 = "DeviceFolder";
            GenModel genModel2 = (GenModel)genModel.getComponent(string3);
            string3 = "Ibm2212Adap";
            object = (GenModel)genModel2.getComponent(string3);
            string3 = "Ibm2212Graphic";
            this.portsModel = (GenModel)genModel2.getComponent(string3);
            string3 = "CommunicationsFolder";
            GenModel genModel3 = (GenModel)object2.getComponent(string3);
            string3 = "MediaFolder";
            GenModel genModel4 = (GenModel)genModel3.getComponent(string3);
            string3 = "Mib2";
            GenModel genModel5 = (GenModel)genModel4.getComponent(string3);
            string3 = "Interface";
            this.interfaceModel = (GenModel)genModel5.getComponent(string3);
            int n3 = 0;
            if (this.deviceType == 1 || this.deviceType == 2) {
                n3 = 6;
            } else if (this.deviceType == 5 || this.deviceType == 6) {
                n3 = 7;
            }
            BoxInfo.moduleLocation[n3] = systemLocation[this.deviceType];
            BoxInfo.moduleLocationcc5[n3] = systemLocation[this.deviceType];
            Vector vector = object.getRestOfInfo("Panel", "default", null, null);
            if (vector != null) {
                if (!(this.deviceType != 3 && this.deviceType != 4 || this.cc5)) {
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        ModelInfo modelInfo = (ModelInfo)vector.elementAt(n4);
                        Serializable serializable2 = modelInfo.get("Panel.Ibm2212AdapSlotNum");
                        Serializable serializable3 = modelInfo.get("Panel.Ibm2212AdapType");
                        if (!(serializable2 instanceof Integer) || !(serializable3 instanceof Integer)) {
                            if (RAS.isEnabled(19, 15)) {
                                RAS.trace(19, 15, this, string2, "Special values in adapterType");
                            }
                        } else {
                            int n5 = (Integer)serializable2;
                            int n6 = (Integer)serializable3;
                            if (n6 != 1 && n6 != 2) {
                                if (n5 > 0 && n6 == 7) {
                                    n6 = 13;
                                }
                                CookieTray cookieTray = new CookieTray("ibm.nways.jdm2212.Resources", moduleLocation[n5 + n3], moduleGif[n6], moduleName[n6], this.deviceBrowser, (GenModel)object, "ibm.nways.jdm2212.eui.Ibm2212AdapPanel");
                                this.moduleInfo[((Integer)serializable2).intValue()] = new ModuleInfo(cookieTray, n6);
                                if (n5 + n3 == 5) {
                                    this.moduleInfo[0].getModuleTray().add((GraphicContainer)cookieTray);
                                } else if (n5 + n3 == 7) {
                                    this.moduleInfo[0].getModuleTray().add((GraphicContainer)cookieTray);
                                } else {
                                    this.frontView.add((GraphicContainer)cookieTray);
                                }
                            }
                        }
                        ++n4;
                    }
                } else if (this.deviceType < 5) {
                    int n7 = 0;
                    while (n7 < vector.size()) {
                        ModelInfo modelInfo = (ModelInfo)vector.elementAt(n7);
                        Serializable serializable4 = modelInfo.get("Panel.Ibm2212AdapSlotNum");
                        Serializable serializable5 = modelInfo.get("Panel.Ibm2212AdapType");
                        if (!(serializable4 instanceof Integer) || !(serializable5 instanceof Integer)) {
                            if (RAS.isEnabled(19, 15)) {
                                RAS.trace(19, 15, this, string2, "Special values in adapterType");
                            }
                        } else {
                            int n8 = (Integer)serializable4;
                            int n9 = (Integer)serializable5;
                            System.out.println("SLOT = " + n8 + "  TYPE = " + n9 + " (" + moduleName[n9] + ")");
                            System.out.println("ModuleAdjustment = " + n3);
                            if (n9 != 1 && n9 != 2) {
                                if (n8 > 0 && n9 == 7) {
                                    n9 = 13;
                                }
                                CookieTray cookieTray = new CookieTray("ibm.nways.jdm2212.Resources", moduleLocationcc5[n8 + n3], moduleGif[n9], moduleName[n9], this.deviceBrowser, (GenModel)object, "ibm.nways.jdm2212.eui.Ibm2212AdapPanel");
                                this.moduleInfo[((Integer)serializable4).intValue()] = new ModuleInfo(cookieTray, n9);
                                if (n8 + n3 == 5) {
                                    this.moduleInfo[0].getModuleTray().add((GraphicContainer)cookieTray);
                                } else if (n8 + n3 == 7) {
                                    this.moduleInfo[0].getModuleTray().add((GraphicContainer)cookieTray);
                                } else {
                                    this.frontView.add((GraphicContainer)cookieTray);
                                }
                            }
                        }
                        ++n7;
                    }
                } else if (this.deviceType == 7 || this.deviceType == 8) {
                    CookieTray cookieTray = new CookieTray("ibm.nways.jdm2212.Resources", new Point(210, 75), "systemcardhighperf.gif", "systemhighperf", this.deviceBrowser, (GenModel)object, "ibm.nways.jdm2212.eui.Ibm2212AdapPanel");
                    int n10 = 1;
                    while (n10 < 3) {
                        WidgetCookie widgetCookie = new WidgetCookie("Prt" + n10 + "ConR2", "ibm.nways.jdm2212.Resources", null, this.getSerPath(), this.interfaceModel, this.deviceBrowser, 18);
                        cookieTray.add((GraphicContainer)widgetCookie);
                        ++n10;
                    }
                    int n11 = 0;
                    while (n11 < vector.size()) {
                        ModelInfo modelInfo = (ModelInfo)vector.elementAt(n11);
                        Serializable serializable6 = modelInfo.get("Panel.Ibm2212AdapSlotNum");
                        Serializable serializable7 = modelInfo.get("Panel.Ibm2212AdapType");
                        if (!(serializable6 instanceof Integer) || !(serializable7 instanceof Integer)) {
                            if (RAS.isEnabled(19, 15)) {
                                RAS.trace(19, 15, this, string2, "Special values in adapterType");
                            }
                        } else {
                            int n12 = (Integer)serializable6;
                            int n13 = (Integer)serializable7;
                            if (n13 != 1 && n13 != 2 && (n12 != 2 && n12 != 4 || n13 != 16 && n13 != 17)) {
                                CookieTray cookieTray2 = new CookieTray("ibm.nways.jdm2212.Resources", moduleLocationR2[n12 + n3], moduleGif[n13], moduleName[n13], this.deviceBrowser, (GenModel)object, "ibm.nways.jdm2212.eui.Ibm2212AdapPanel");
                                this.moduleInfo[((Integer)serializable6).intValue()] = new ModuleInfo(cookieTray2, n13);
                                if (n12 == 5 || n12 == 6) {
                                    cookieTray.add((GraphicContainer)cookieTray2);
                                } else {
                                    this.frontView.add((GraphicContainer)cookieTray2);
                                }
                            }
                        }
                        ++n11;
                    }
                    this.frontView.add((GraphicContainer)cookieTray);
                } else if (this.deviceType == 5 || this.deviceType == 6) {
                    CookieTray cookieTray = new CookieTray("ibm.nways.jdm2212.Resources", new Point(55, 13), "systemcardhighperf.gif", "systemhighperf", this.deviceBrowser, (GenModel)object, "ibm.nways.jdm2212.eui.Ibm2212AdapPanel");
                    int n14 = 1;
                    while (n14 < 3) {
                        WidgetCookie widgetCookie = new WidgetCookie("Prt" + n14 + "ConR2", "ibm.nways.jdm2212.Resources", null, this.getSerPath(), this.interfaceModel, this.deviceBrowser, 18);
                        cookieTray.add((GraphicContainer)widgetCookie);
                        ++n14;
                    }
                    int n15 = 0;
                    while (n15 < vector.size()) {
                        ModelInfo modelInfo = (ModelInfo)vector.elementAt(n15);
                        Serializable serializable8 = modelInfo.get("Panel.Ibm2212AdapSlotNum");
                        Serializable serializable9 = modelInfo.get("Panel.Ibm2212AdapType");
                        if (!(serializable8 instanceof Integer) || !(serializable9 instanceof Integer)) {
                            if (RAS.isEnabled(19, 15)) {
                                RAS.trace(19, 15, this, string2, "Special values in adapterType");
                            }
                        } else {
                            int n16 = (Integer)serializable8;
                            int n17 = (Integer)serializable9;
                            if (n17 != 1 && n17 != 2 && (n16 != 2 || n17 != 16 && n17 != 17)) {
                                CookieTray cookieTray3 = new CookieTray("ibm.nways.jdm2212.Resources", moduleLocationR2[n16 + n3], moduleGif[n17], moduleName[n17], this.deviceBrowser, (GenModel)object, "ibm.nways.jdm2212.eui.Ibm2212AdapPanel");
                                this.moduleInfo[((Integer)serializable8).intValue()] = new ModuleInfo(cookieTray3, n17);
                                if (n16 == 1 || n16 == 2) {
                                    cookieTray.add((GraphicContainer)cookieTray3);
                                } else {
                                    this.frontView.add((GraphicContainer)cookieTray3);
                                }
                            }
                        }
                        ++n15;
                    }
                    this.frontView.add((GraphicContainer)cookieTray);
                }
            }
            this.add2212Ports();
        }
        catch (Exception exception) {
            RAS.logError(19, 15, this, string2, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)string3, (Object)"Jdm2212Model");
            RAS.logException(19, 15, this, string2, exception);
            new BoxDownMsg(this.deviceBrowser.getFrame(), this.jdm2212Bundle.getString("deviceName"));
        }
        graphicContainer.add((GraphicContainer)this.frontView);
        this.deviceGraphic = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)graphicContainer);
        return this.deviceGraphic;
    }

    private void add2212Ports() {
        String string = "add2212Ports";
        ModelInfo modelInfo = new ModelInfo();
        String string2 = "ibm.nways.mib2.eui.Mib2InterfacesPanel";
        String string3 = this.getSerPath();
        JdmBrowser jdmBrowser = this.getDeviceBrowser();
        GenModel genModel = this.getPortsModel();
        GenModel genModel2 = this.getInterfaceModel();
        String string4 = "xx";
        Vector vector = null;
        try {
            if (RAS.isEnabled(19, 15)) {
                RAS.trace(19, 15, this, string, "Adding Ports");
            }
            vector = genModel.getRestOfInfo("Panel", "default", null, null);
            WidgetCookie widgetCookie = new WidgetCookie("PortCons", "ibm.nways.jdm2212.Resources", null, this.getSerPath(), genModel2, jdmBrowser, 18);
            if (this.deviceType < 5) {
                this.moduleInfo[0].getModuleTray().AddWidget(widgetCookie);
            }
            int n = 0;
            while (n < vector.size()) {
                ModelInfo modelInfo2 = (ModelInfo)vector.elementAt(n);
                Serializable serializable = modelInfo2.get("Index.Ibm2212GraphicSlotNum");
                Serializable serializable2 = modelInfo2.get("Panel.Ibm2212GraphicifIndex");
                Serializable serializable3 = modelInfo2.get("Index.Ibm2212GraphicPortNum");
                if (!(serializable instanceof Integer && serializable2 instanceof Integer && serializable3 instanceof Integer)) {
                    if (RAS.isEnabled(19, 15)) {
                        RAS.trace(19, 15, this, string, "Special values in portrow");
                    }
                } else {
                    int n2 = (Integer)serializable;
                    int n3 = (Integer)serializable3;
                    Integer n4 = (Integer)serializable2;
                    if (this.moduleInfo[n2] != null) {
                        this.moduleInfo[n2].getAdapterType();
                        string4 = this.moduleInfo[n2].getAdapterPrefix();
                        modelInfo = new ModelInfo();
                        modelInfo.add("Index.IfIndex", n4);
                        if (RAS.isEnabled(19, 15)) {
                            RAS.trace(19, 15, this, string, "Cookie from Database is Port" + string4 + n3);
                        }
                        widgetCookie = new WidgetCookie("Port" + string4 + n3, "ibm.nways.jdm2212.Resources", modelInfo, string3, genModel2, jdmBrowser, 16, string2);
                        this.moduleInfo[n2].getModuleTray().AddWidget(widgetCookie);
                        this.moduleInfo[n2].markPort(n3);
                    }
                }
                ++n;
            }
            int n5 = 1;
            while (n5 < this.moduleInfo.length) {
                if (this.moduleInfo[n5] != null) {
                    this.moduleInfo[n5].setNonMembers();
                }
                ++n5;
            }
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 15, this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Port Table", (Object)"Jdm2212Model");
            RAS.logException(19, 15, this, string, exception);
            return;
        }
    }

    public void dispose() {
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        int n = 0;
        while (n < 5) {
            if (this.moduleInfo[n] != null) {
                this.moduleInfo[n].dispose();
            }
            this.moduleInfo[n] = null;
            ++n;
        }
    }

    private CookieTray createModel(GenModel genModel) {
        CookieTray cookieTray = new CookieTray("ibm.nways.jdm2212.Resources", new Point(30, 25), modelGif[this.deviceType], modelName[this.deviceType], this.deviceBrowser, genModel, "ibm.nways.mib2.eui.SystemPanel");
        return cookieTray;
    }

    private class ModuleInfo {
        CookieTray tray;
        int adapterType;
        int numberOfPorts;
        boolean[] portsAdded;
        public final int[] portsList;
        public final String[] portsPrefix;

        public ModuleInfo(CookieTray cookieTray, int n) {
            BoxInfo.this = BoxInfo.this;
            int[] nArray = new int[23];
            nArray[3] = 1;
            nArray[4] = 1;
            nArray[5] = 2;
            nArray[6] = 2;
            nArray[7] = 4;
            nArray[8] = 2;
            nArray[9] = 2;
            nArray[10] = 1;
            nArray[11] = 1;
            nArray[13] = 4;
            nArray[14] = 2;
            nArray[15] = 2;
            nArray[16] = 1;
            nArray[17] = 1;
            nArray[18] = 4;
            nArray[19] = 2;
            nArray[20] = 2;
            nArray[21] = 2;
            nArray[22] = 4;
            this.portsList = nArray;
            this.portsPrefix = new String[]{"", "UN", "NP", "SR", "SR", "EN", "TR", "SY", "IS", "ST", "IS", "IS", "CE", "WA", "IS", "IS", "DM", "DM", "AM", "VO", "VO", "VO", "SP"};
            this.tray = cookieTray;
            this.adapterType = n;
            this.numberOfPorts = this.portsList[n];
            this.portsAdded = new boolean[this.numberOfPorts + 1];
            int n2 = 0;
            while (n2 < this.portsAdded.length) {
                this.portsAdded[n2] = false;
                ++n2;
            }
        }

        public String getAdapterPrefix() {
            return this.portsPrefix[this.adapterType];
        }

        public int getAdapterType() {
            return this.adapterType;
        }

        public CookieTray getModuleTray() {
            return this.tray;
        }

        public void markPort(int n) {
            this.portsAdded[n] = true;
        }

        public void setNonMembers() {
            int n = 1;
            while (n < this.portsAdded.length) {
                if (!this.portsAdded[n]) {
                    WidgetCookie widgetCookie = new WidgetCookie("Port" + this.portsPrefix[this.adapterType] + n, "ibm.nways.jdm2212.Resources", BoxInfo.this.getSerPath(), BoxInfo.this.deviceBrowser, 16);
                    this.getModuleTray().AddWidget(widgetCookie);
                }
                ++n;
            }
        }

        public void dispose() {
        }
    }
}

